s           Z                                          bp4462      Burster Digistant Type 4462                   ?      Instrument Name: burster DIGISTANT Type 4462

  Description:   This instrument module provides
                 RS232 and IEEE488.2 support for 
                 DIGISTANT Type 4462 from burster.

  Functions and Classes:

  (1) Initialize:
      Initialize the instrument and sets to
      default configuration

  (2) Configure:
      Configures the instrument by setting the
      Voltage, Current, TC, RJ and Output a Value

  (3) System:
      Reads the system error
      Reads the instrument ID-String
      Controls the keyboard
      Sends a SCPI-Message 
      Receives a SCPI-Message

  (4) Store/Load:
      Stores and loads values to and from device.

  (5) Close:
      Takes the instrument off-line.

  (6) Calibration:
      Special functions for the manufacturer to calibrate
      the device.
      *********
     u     Class Name:    Initialize

 Description:   Initializes the Serial or GPIB interface 
                of the device     f     Class Name:    Configure

 Description:   Sets up all configurations
                for the device          Class Name:    Ramp 1

 Description:   Sets up all necessary functions
                for working with the ramp 1 function
                of the DIGISTANT          Class Name:    Ramp 2

 Description:   Sets up all necessary functions
                for working with the ramp 2 function
                of the DIGISTANT     `     Class Name:    Range

 Description:   Sets up the range mode
                of the DIGISTANT     E     Panel Name:    Get Config Range

 Description:   Gets the range 

          Panel Name:    Set Config Range

 Description:   Configure the instrument range in
                following ways:

                - Selects the Auto range function
                  or sets the range manuall
          Class Name:    RJ

 Description:   Sets up all necessary functions
                for working with the Reference Junction   
                functions of the DIGISTANT          Panel Name:    Get Config Temp. Compensation

 Descrpition:   
                - Gets the state 
                - Gets the manual temperature

          Class Name:    TC

 Description:   Sets up all necessary functions
                for working with the TC   
                functions of the DIGISTANT          Class Name:    PT100

 Description:   Sets up all necessary functions
                for working with the PT 100   
                functions of the DIGISTANT          Panel Name:    Get Config Scale PT100

 Description:   Gets the scale parameter of the
                PT100 function

 Formula :      Rt = R0 *(1 + "a" * t + "b" * t^2 )          Panel Name:    Get Config Scale PT100

 Description:   Gets the scale parameter of the
                PT100 function

 Formula :      Rt = R0 *(1 + "a" * t + "b" * t^2 )          Panel Name:    Set Config Scale PT100

 Description:   Scale the PT100 function

 Formula :      Rt = R0 *(1 + "a" * t + "b" * t^2 )     j     Class Name:    Output

 Description:   Sets up the output   
                functions of the DIGISTANT     n     Class Name:    Limit

 Description:   Sets up the Limit Value   
                functions of the DIGISTANT     {     Class Name:    Status / Values

 Description:   Sets up the Output Status and Values   
                of the DIGISTANT     m     Class Name:    Mode

 Description:   Sets up the Output Mode   
                functions of the DIGISTANT     h     Class Name:    Sense

 Description:   Sets up the sense   
                functions of the DIGISTANT           Class Name:  Config Display

   Description: Class of functions for configure
                the display functions of the device
                of following parameters:

                - Configure the display options
                - Configure the display contrast
          Panel Name:    Set Config Display Mode

 Description:   Configure the instrument display mode
                following ways:

                - Selects the display mode
                - Selects the display resolution
                
     X     Panel Name:    Set Config Display Contrast

 Descrpition:   Set the display contrast
     Y     Panel Name:    Get Config Display Contrast

 Descrpition:   Gets the display contrast
          Class Name:    Device Access

 Description:   Sets up all necessary functions
                for Device Access 
                functions of the DIGISTANT          Panel Name:    Config Device Access

 Description:   Configure the access to the device
                menues.

                
          Panel Name:    Set Config Device Access

 Description:   Configure the access to the device
                menues.

                
          Class Name:    Voltage Dividor

 Description:   Sets up all necessary functions
                for the Voltage Dividor  
                functions of the DIGISTANT          Class Name:    Delta Value

 Description:   Sets up all necessary functions
                for the Delta Value 
                functions of the DIGISTANT           Class Name:  System

   Description: Class of functions for setting the
                follow parameters:

                - Read the output register
                - Read the input register
                - Read the system error of device
                - Control the keyboard of the
                  decive
                - Send and receive SCPI-message
                     U     Panel Name:   System Keybroad

 Description:  Controls the keybroad of the device
     m     Class Name:    Device Error

 Description:   Checks the Error registers  
                of the DIGISTANT     k     Class Name:    SCPI

 Description:   Send and Receive SCPI   
                functions of the DIGISTANT          Panel Name:   Receive a SCPI-Message

 Descrpition:  Send "Query form" from SCPI-
               Message and receive a answers
               => Polling     g     Panel Name:   Send a SCPI-Message

 Descrpition:  Send every SCPI-Message to a
               slave      O     Class Name:    Register

 Description:   Register functions of the DIGISTANT          Class Name:    Store/Load Configuration

 Description:   Sets up all necessary store/load  
                configuration functions for the device     y     Panel Name:    Set Memory Labels

 Description:   Store the memory label to the
                specificies memory No.     {     Panel Name:    Get Memory Label

 Description:   Return the memory label from the
                specificies memory No.          Panel Name:    Store Memory No.

 Description:   Store the actual Parameters to
                the selected memory of the
                instrument
          Panel Name:    Get Memory No.

 Description:   Recall the actual Parameters to
                the selected memory of the
                instrument
    6     Panel Name:    Initialize Gpib

 Description:   Initializes the instrument by:
 1) finding an unused device in the device table
    using the supplied GPIB address
 2) device clear and RESET  (if desired)
 3) returns the ID-String of the instrument
 4) returns an instrument ID

 This is a multi-instrument driver, allowing
 multiple Digistant 4462 instruments to be
 controlled.
 During the initialization, the returned ID is
 based on the GPIB address.  This ID is used in
 all of the other functions to distinguish
 between multiple Digistant 4462 instruments.    5     Control Name:  Error

 Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid GPIB Address
 -2     Invalid Reset

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator
          Control Name:  Reset

 Description:   If reset is on, a device clear and
 power on reset is done during initialization.

 Variable Type: Integer

 Valid Range:   0 to 1
                0  off
                1  on
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.              Error                              A
          Reset                                         Instrument ID                    A G          Adress                             	            On 1 Off 0    	                                     Panel Name:    Initialize Serial

 Description:   Initializes the instrument by:
 1) select the used COM-Port
 2) device clear and RESET  (if desired)
 3) configurate the interface
  
         Control Name:   COM-Port

 Description:    Specifies the COM-Port to be
                 used to communicate with the
                 instrument.

 Variable Type:  Integer

 Valid Values:   1 - COM1   (=> Adress 0x3f8 IRQ4)
                 2 - COM2   (=> Adress 0x2f8 IRQ3)
                 3 - COM3   (=> Adress 0x3e8 IRQ4)
                 4 - COM4   (=> Adress 0x2e8 IRQ3)

 Default:        1         Control Name:   Baud Rate

 Description:    Specifies the baud rate of the
                 RS232-Port to communicate with
                 the instrument. This value must
                 correspond to the current
                 internal setting of the
                 instrument.

 Variable Type:  Integer

 Valid Values:   300,600,1200,2400,4800,9600,19200 or 38400 baud

 Default:        9600    v     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   COM-Port is out of range
       -2   Baud Rate is out of range
       -3   Data-Configuration is out of range
       -4   Delay-Time is out of range
       -5   Reset Device is out of range
      
  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    D    Control Name:   DataConfig

 Description:   The protocoll of the data transmittion can be       
                configurated.

 Variable Type: Integer

 Valid Range:   0 to 6
                0 = 8 Databits, 1 Stopbit,  No Parity
                1 = 8 Databits, 1 Stopbit,  Even Parity
                2 = 8 Databits, 1 Stopbit,  Odd Parity
                3 = 8 Databits, 2 Stopbits, No Parity
                4 = 7 Databits, 1 Stopbit,  Even Parity
                5 = 7 Databits, 1 Stopbit,  Odd Parity
                6 = 7 Databits, 2 Stopbits, No Parity

 Default Value: 0          Control Name:  Reset

 Description:   If reset is on, a device clear and
 power on reset is done during initialization.

 Variable Type: Integer

 Valid Range:   0 to 1
                0 = off
                1 = on
    *     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.
    # A 4           COM-Port                          %q '           Baud Rate                         '          Error                             * -         DataConfig                        , I          Reset                             -           Instrument ID                                 1 1 2 2 3 3 4 4              P300 300 600 600 1200 1200 2400 2400 4800 4800 9600 9600 19200 19200 38400 38400    	                       8Databits/1Stopbit/NoParity 0 8Databits/1Stopbit/EvenParity 1 8Databits/1Stopbit/OddParity 2 8Databits/2Stopbits/NoPatity 3 7Databits/1Stopbit/EvenParity 4 7Databits/1Stopbit/OddParity 5 7Databits/2Stopbits/NoParity 6    On 1 Off 0    	                Panel Name:    Set Config Ramp1

 Description:   Configure the ramp function 1
                of the instrument in following
                ways :

                - Select the instrument
                - Select the waveform
                - Input the step time (hour, minute, seconds)
                - Select the unit
                - Input the step value
                - Input the start value
                - Input the stop value
               

          Control Name:   Waveform

 Description:    Specifies the waveform  of ramp1

 Variable Type:  Integer

 Valid Values:   0 = Sawtooth
                 1 = Triangle

 Default Value:  0 = Sawtooth          Control Name:   Number of Counts

 Description:    Specifies the number of counts
                 of ramp1

 Variable Type:  Integer

 Valid Range:    0 to 99
                 0 = Countiue

 Default:        1
          Control Name:   Step Time (minutes)

 Description:    Specifies the minutes of step time

 Variable Type:  Integer

 Valid Range:    0 to 59 minutes

 Default:        0
    "     Control Name:   Start Value

 Description:    Specifies the start value of
                 ramp1

 Variable Type:  Double

 Valid Range:    by Voltage -30 to 30 V
                 by Current -52 to 52 mA
                 by TC      0   to 3000 K
                 
 Default:        0.0

         Control Name:   End Value

 Description:    Specifies the end value of
                 ramp1

 Variable Type:  Double

 Valid Range:    by Voltage -30 to 30 V
                 by Current -52 to 52 mA
                 by TC      0   to 3000 K
                
 Default:        0.0


         Control Name:   Step Value

 Description:    Specifies the step value of
                 ramp1

 Variable Type:  Double

 Valid Range:    by Voltage 0 to 60 V
                 by Current 0 to 104 mA
                 by TC      0 to 3000 K
                 

 Default:        0.0
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Waveform
       -3   Invalid Unit
       -4   Invalid Number of Counts
       -5   Invalid Step Value
       -6   Invalid Step Time (hour)
       -7   Invalid Step Time (minute)
       -8   Invalid Step Time (seconds)
       -9   Invalid Start Value
       -10  Invalid Stop Value
       -11  Invalid Step Value


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

                Control Name:   Step Time (hours)

 Description:    Specifies the hours of step time

 Variable Type:  Integer

 Valid Range:    0 to 99 hours

 Default:        0
          Control Name:   Step Time (seconds)

 Description:    Specifies the seconds of step time

 Variable Type:  Double

 Valid Range:    0.0 to 59.9 seconds

 Default:        1.0
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:   Unit

 Description:    Specifies the Unit of the Ramp1 Values.

 Variable Type:  Integer

 Valid Values:   0 to 7

                 0 = Voltage (V)       
                 1 = Voltage (mV)
                 2 = Voltage (V)
                 3 = Current (A)       
                 4 = Current (mA)
                 5 = Temperature (C)       
                 6 = Temperature (F)
                 7 = Temperature ( K)

 Default Value:  0 = Voltage (V) 
         Control Name:   Device Version
 Description:    Switch between the 30 Volts and 60 Volts
                 Device Version of Digistant 4462.
                 The 60 Volts Version is comming since 
                 Device Software Version 200201.

 Variable Type:  Integer

 Valid Values:   0 = 30 Volts Version
                 1 = 60 Volts Version

 Default Value:  0 = 30 Volts Version    3 $           Waveform                          4W !:          Number Of Counts                  54 b:          Step Time[min]                    5 :         Start Value                       7  	        End Value                         88           Step Value                        9[          Error                             =} b           Step Time[h]                      >+ b         Step Time[sec]                    > "            Instrument ID                     @           Unit                              A   
        Device Version                    Sawtooth 0 Triangle 1    1    0    0.0    0.0    0.0    	            0    1.0    1               Voltage [V] 0 Voltage [mV] 1 Voltage [V] 2 Current [A] 3 Current [mA] 4 Temperature [C] 5 Temperature [F] 6 Temperature [K] 7               30 V 0 60 V 1        Panel Name:    Get Config Ramp1

 Description:   Gets the ramp function 1 configuration 
                of the instrument in following
                ways :

                - Selected waveform
                - Number of counts
                - Step time
                - Output type and unit
                - Start value
                - End value
                - Step value

    Y     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Error Waveform return
       -3   Error Start Unit return
       -4   Error Stop Unit return
       -5   Error Step Unit return


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

               Control Name:   Waveform

 Description:    Displays the waveform of ramp1

 Variable Type:  Integer

 Valid Values:   0 = Sawtooth
                 1 = Triangle

 Default Value:  0 = Sawtooth          Control Name:   Number of Counts

 Description:    Displays the number of counts
                 of ramp1

 Variable Type:  Integer

 Valid Range:    0 to 99
                 0 = Countiue

 Default:        1
     l     Control Name:   Step Value

 Description:    Displays the step value of ramp1

 Variable Type:  Double

      r     Control Name:   Step Time (hours)

 Description:    Displays the hours of step time

 Variable Type:  Integer

     v     Control Name:   Step Time (minutes)

 Description:    Displays the minutes of step time

 Variable Type:  Integer

     u     Control Name:   Step Time (seconds)

 Description:    Displays the seconds of step time

 Variable Type:  Double

         Control Name:   Start Unit

 Description:    Displays the start unit of the 
                 ramp1 start value

 Variable Type:  Integer

 Valid Units:    0 to 7

                 0 = Voltage (V)       
                 1 = Voltage (mV)
                 2 = Voltage (V)
                 3 = Current (A)       
                 4 = Current (mA)
                 5 = Temperature (C)       
                 6 = Temperature (F)
                 7 = Temperature ( K)

 
          Control Name:   Start Value

 Description:    Displays the start value of
                 ramp1

 Variable Type:  Double


                 
 
         Control Name:   Stop Unit

 Description:    Displays the stop unit of the 
                 ramp1 stop value

 Variable Type:  Integer

 Valid Units:    0 to 7

                 0 = Voltage (V)       
                 1 = Voltage (mV)
                 2 = Voltage (V)
                 3 = Current (A)       
                 4 = Current (mA)
                 5 = Temperature (C)       
                 6 = Temperature (F)
                 7 = Temperature ( K)

 
          Control Name:   Stop Value

 Description:    Displays the stop value of
                 ramp1

 Variable Type:  Double


                          Control Name:   Step Unit

 Description:    Displays the step unit of the 
                 ramp1 step value

 Variable Type:  Integer

 Valid Units:    0 to 7

                 0 = Voltage (V)       
                 1 = Voltage (mV)
                 2 = Voltage (V)
                 3 = Current (A)       
                 4 = Current (mA)
                 5 = Temperature (C)       
                 6 = Temperature (F)
                 7 = Temperature ( K)

 
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    H         Error                             K            Waveform                          L            Number Of Counts                  M      `    Step Value                        N Z           Step Time[h]                      N Z           Step Time[min]                    O Zw         Step Time[sec]                    O w          Start Unit                        Qb   	        Start Value                       Q   
         Stop Unit                         S w         Stop Value                        Tr            Step Unit                         VQ             Instrument ID                      	            	            	            	           	            	            	           	            	           	            	           	            1   Q     Panel Name:    Set Config List Ramp2 

 Description:   Sets the ramp function 2 configuration
                of the instrument in following
                ways :

                - Select the output type and unit
                - Input the List No.
                - Input the List value
                - Input the List step time
          Control Name:   List No

 Description:    Specifies the List No. of the
                 ramp2 configuration

 Variable Type:  Integer

 Valid Range:    1 to 31

 Default:        1
    0     Control Name:   Value

 Description:    Specifies the value of the
                 selected List No. of ramp2

 Variable Type:  Double

 Valid Range:    by Voltage -30 to 30 V
                 by Current -52 to 52 mA
                 by TC    -3000 to 3000 K 
                 
 Default:        0.0

          Control Name:   Step Time[sec]

 Description:    Specifies the seconds of step time
                 in the selected List No.

 Variable Type:  Double

 Valid Range:    0.0 to 59.9 seconds

 Default:        1.0
    p     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Unit
       -3   Invalid List No.
       -4   Invalid Step Time hour
       -5   Invalid Step Time minute
       -6   Invalid Step Time seconds

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

               Control Name:   Step Time[min]

 Description:    Specifies the minutes of the step time
                 in the selected List No. 

 Variable Type:  Integer

 Valid Range:    0 to 59

 Default:        0
          Control Name:   Step Time[h]

 Description:    Specifies the hours of step time
                 in the selected List No.

 Variable Type:  Integer

 Valid Range:    0 to 99

 Default:        0
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:   Unit

 Description:    Specifies the unit of the ramp2 value

 Variable Type:  Integer

 Valid Range:    0 to 7

                 0 = Voltage (V)       
                 1 = Voltage (mV)
                 2 = Voltage (V)
                 3 = Current (A)       
                 4 = Current (mA)
                 5 = Temperature (C)       
                 6 = Temperature (F)
                 7 = Temperature ( K)

 Default Value:  0 = Voltage (V)
         Control Name:   Device Version
 Description:    Switch between the 30 Volts and 60 Volts
                 Device Version of Digistant 4462.
                 The 60 Volts Version is comming since 
                 Device Software Version 200201.

 Variable Type:  Integer

 Valid Values:   0 = 30 Volts Version
                 1 = 60 Volts Version

 Default Value:  0 = 30 Volts Version    \! ?           List No                           \ ?*         Value                             ^ ~         Step Time[sec]                    ^          Error                             bo ~*          Step Time[min]                    cE ~           Step Time[h]                      d 5 #           Instrument ID                     eC $         Unit                              g" r         Device Version                     1    0.0    1.0    	            0    0    1               Voltage [V] 0 Voltage [mV] 1 Voltage [V] 2 Current [A] 3 Current [mA] 4 Temperature [C] 5 Temperature [F] 6 Temperature [K] 7               30 V 0 60 V 1        Panel Name:    Get Config List Ramp2 

 Description:   Gets the ramp function 2 configuration
                of the instrument in following
                ways :

                - Output Unit
                - List No.
                - List Value
                - List Step Time
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Error Unit return

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

              Control Name:   Value

 Description:    Specifies the value of the
                 selected List No.

 Variable Type:  Double

 Valid Range:    by Voltage -30 to 30 V
                 by Current -52 to 52 mA
                 by TC    -3000 to 3000 K 
                 

          Control Name:   Step Time[sec]

 Description:    Displays the seconds of step time
                 in the selected List No.

 Variable Type:  Integer

 Valid Range:    0.0 to 59.9

 Default:        1.0
          Control Name:   Step Time[min]

 Description:    Displays the minutes of step time
                 in the selected List No.

 Variable Type:  Integer

          Control Name:   Step Time[h]

 Description:    Displays the hours of step time
                 in the selected List No.

 Variable Type:  Integer

         Control Name:   Unit

 Description:    Specifies the output type and the
                 unit of start, stop and step
                 value

 Variable Type:  Integer

 Valid Units:    0 to 7

                 0 = Voltage (V)       
                 1 = Voltage (mV)
                 2 = Voltage (V)
                 3 = Current (A)       
                 4 = Current (mA)
                 5 = Temperature (C)       
                 6 = Temperature (F)
                 7 = Temperature ( K)
             

 
          Control Name:   List No.

 Description:    Specifies the List No. of the
                 ramp2 configuration

 Variable Type:  Integer

 Valid Range:    1 to 31

 Default:        1
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    l         Error                             o -         Value                             p }         Step Time[sec]                    qq }#          Step Time[min]                    r }           Step Time[h]                      r -           Unit                              t 5$          List No.                          u 5 (           Instrument ID                      	            	           	           	            	            	                1   H     Panel Name:    Set Config Ramp2 

 Description:   Sets the ramp function 2 configuration
                of the instrument in following
                ways :

                - Select the waveform
                - Input the number of counts
                - Input the number of points
                - Input the List No.
          Control Name:   Waveform

 Description:    Specifies the waveform of ramp2

 Variable Type:  Integer

 Valid Values:   0 = Sawtooth
                 1 = Triangle

 Default:        0 = Sawtooth          Control Name:   Number of Counts

 Description:    Specifies the number of counts
                 of ramp2

 Variable Type:  Integer

 Valid Range:    0 to 99
                 0 = Countiue

 Default:        1
          Control Name:   Number of Points

 Description:    Specifies the number of points
                 of ramp2

 Variable Type:  Integer

 Valid Range:    2 to 31

 Default:        2
    V     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Waveform
       -3   Invalid Number of Counts
       -4   Invalid Number of Points
       -5   Invalid List Number


  1 - 124   RS-232 error (see RS-232 Library
            error codes)


      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

                Control Name:   List No

 Description:    Specifies the List No. of the
                 input values

 Variable Type:  Integer

 Valid Range:    1 to 31

 Default:        1
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    y            Waveform                          z 7           Number Of Counts                  { 75          Number Of Points                  |c          Error                              7          List No                           z 7             Instrument ID                     Sawtooth 0 Triangle 1    1    2    	            1    1        Panel Name:    Get Config Ramp2

 Description:   Gets the ramp function 2 configuration
                of the instrument in following
                ways :

                - Waveform
                - Number of counts
                - Number of points
                - List No.
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Error Waveform return

  1 - 124   RS-232 error (see RS-232 Library
            error codes)


      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

              Control Name:   Waveform

 Description:    Displays the waveform of ramp2

 Variable Type:  Integer

 Values:         0 = Sawtooth
                 1 = Triangle

          Control Name:   Number of Counts

 Description:    Displays the number of counts
                 of ramp2

 Variable Type:  Integer

          Control Name:   Number of Points

 Description:    Displays the number of points
                 of ramp2

 Variable Type:  Integer



 
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   List No

 Description:    Specifies the List No. of the 
                 ramp2 configuration
            
 Variable Type:  Integer

 Valid Range:    1 to 31

 Default:        1
    H          Error                             ? D          Waveform                           )          Number Of Counts                  }           Number Of Points                   + #           Instrument ID                     C D*          List No                            	            	            	            	            1    1         Panel Name:    Set Ramp Step

 Description:   Sets the direction for the ramp steps
                in following ways:

                - Ramp steps up
                - Ramp steps down
          Control Name:   Step Direction

 Description:    Specifies the step direction 
                 of the ramp value.

 Variable Type:  Integer

 Valid Values:   0 = Down, 1 = Up

 Default:        0 = Down
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Step Direction

  1 - 124   RS-232 error (see RS-232 Library
            error codes)


      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

        )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    M           Step Direction                    #          Error                              .             Instrument ID                      Up 1 Down 0    	            1    h     Panel Name:    Set Ramp Start/Stop

 Description:   Switch between ramp Start or
                Stop          Control Name:   Start/Stop

 Description:    Specifies the status of the ramp mode.

 Variable Type:  Integer

 Valid Values:   0 = Stop, 1 = Start

 Default:        0 = Stop
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Start/Stop 

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

        )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    { }           Start/Stop                        5         Error                             ) &            Instrument ID                      Start 1 Stop 0    	            1         Panel Name:    Get Config Range Mode

 Description:   Gets the configuration of the Range Mode
                in following ways:

                - Automatic 
                - Manual         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Range


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    #     Control Name:  Range

 Description:   Displays the range mode and the range value
                if range mode is set to manual range. 

 Variable Type: Integer

 Valid Range:   0 = Autorange
                1 = 300 mVolt
                2 = 3 Volt
                3 = 30 Volt
              )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.              Error                              w           Range Mode                         D             Instrument ID                      	            	            1    c     Panel Name:    Set Config Range Mode

 Description:   Switch between Automatic and Manual Range.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Range Mode


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    $     Control Name:  Range

 Description:   Specifies the range mode and the range value
                if range mode is set to manual range. 

 Variable Type: Integer

 Valid Range:   0 = Autorange
                1 = 300 mVolt
                2 = 3 Volt
                3 = 30 Volt
                   Control Name:   Device Version
 Description:    Switch between the 30 Volts and 60 Volts
                 Device Version of Digistant 4462.
                 The 60 Volts Version is comming since 
                 Device Software Version 200201.

 Variable Type:  Integer

 Valid Values:   0 = 30 Volts Version
                 1 = 60 Volts Version

 Default Value:  0 = 30 Volts Version    M          Error                             = A            Instrument ID                     n O          Range Mode                         P         Device Version                     	            1              "Autorange 0 300 mV 1 3 V 2 30 V 3               30 V 0 60 V 1         Panel Name:    Get RJ Temperature Value Extern

 Description:   Gets the temperature value and unit of the
                external reference junction.          Control Name:   Value

 Description:    Displays the rj-temperature value. 
                 
 Variable Type:  Double

 
 
                 
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
 
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Unit return


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

         Control Name:  Unit

 Description:   Displays the temperature unit of the 
                rj-temperature value.

 Variable Type: Integer

 Valid Range:   5 to 7

                5 = C (Celsius)
                6 = F (Farenheit)
                7 =  K (Kelvin)

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.     3        Value                                       Error                                         Unit                               4 0           Instrument ID                      	           	            	            1         Panel Name:    Set RJ Temperature Value Manual

 Description:   Sets the temperature value and unit for the 
                manual reference junction.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
 
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Range Mode


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    ;     Control Name:  Unit

 Description:   Specifies the temperature unit of the 
                rj-temperature value.

 Variable Type: Integer

 Valid Range:   5 to 7

                5 = C (Celsius)
                6 = F (Farenheit)
                7 =  K (Kelvin)

 Default Value: 5 = C (Celsius)                        Control Name:   Value

 Description:    Specifies the rj-temperature value. 
                
 Variable Type:  Double

 Valid Range:    -50.00 to 150.00 C
                 -58.00 to 302.00 F
                 223.15 to 423.15  K 

 Default Value:  0.0
                 
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    j         Error                             \ z          Unit                               7         Value                              '            Instrument ID                      	                       C 5 F 6  K 7    0.0    1         Panel Name:    Get RJ Temperature Value Manual

 Description:   Gets the temperature value and unit of the
                manual adjusted reference junction.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
 
        0   Success
       -1   Invalid Instrument ID
       

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    %     Control Name:  Temperature Unit

 Description:   Displays the temperature unit of the 
                rj-temperature value.

 Variable Type: Integer

 Valid Range:   5 to 7

                5 = C (Celsius)
                6 = F (Farenheit)
                7 =  K (Kelvin)

                   z     Control Name:   Value

 Description:    Displays the rj-temperature value. 
                
 Variable Type:  Double

     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.              Error                             w            Unit                               *         Value                             & ) #           Instrument ID                      	            	            	           1    _     Panel Name:    Set Config RJ Type

 Description:   Switch between RJ-External and RJ-Manual.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
 
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid RJ-Type
       

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    6     Control Name:  RJ-Type

 Description:   Specifies the mode of reference junction type.

 Variable Type: Integer

 Valid Range:   0 to 1

                0 = Manual Reference Junction Type
                1 = External Reference Junction Type

 Default Value: 0 = Manual Reference Junction Type                   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.              Error                             ±            RJ-Type                            3 (           Instrument ID                      	            RJ.-MAN 0 RJ-EXT 1    1         Panel Name:    Get Config RJ Type

 Description:   Gets the configured RJ-Type in following
                ways:

                - RJ-External
                - RJ-Manual         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
 
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid RJ-Type return
       

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  RJ-Type

 Description:   Displays the mode of reference junction type.

 Variable Type: Integer

 Valid Range:   0 to 1

                0 = Manual Reference Junction Type
                1 = External Reference Junction Type

          )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    Ɲ s         Error                             ɚ            RJ-Type                           ʜ 6 .           Instrument ID                      	            	            1    T     Panel Name:    Set Config TC Unit

 Description:   Sets the unit for the TC-mode.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
 
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid TC-Unit
       

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

         Control Name:  Unit

 Description:   Specifies the tc-temperature unit.

 Variable Type: Integer

 Valid Range:   5 to 7

                5 = C (Celsius)
                6 = F (Fahrenheit)
                7 =  K (Kelvin)

 Default Value: 5 = C (Celsius)                   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.              Error                              P         Unit                               ! #           Instrument ID                      	                       C 5 F 6  K 7    1    X     Panel Name:    Set Config TC

 Description:   Sets the configuration for the TC-mode.         Control Name:   Type

 Description:    Specifies the TC-Type.

 Variable Type:  Integer

 Valid Values:   0 = R
                 1 = S
                 2 = B
                 3 = J
                 4 = T
                 5 = E
                 6 = K
                 7 = U
                 8 = L
                 9 = N
                10 = C
                11 = D
                12 = G2
                13 = M

 Default Value:  0 = R          Control Name:  Scale

 Description:   Specifies the tc-temperature scale.

 Variable Type: Integer

 Valid Range:   0 to 1

                0 = IPTS 68
                1 = ITS 90

 Default Value: 1 = ITS 90      )     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
 
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid TC-Type 
       -3   Invalid TC-Scale 
       -4   Invalid TC-Unit
       

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

         Control Name:  Unit

 Description:   Specifies the tc-temperature unit.

 Variable Type: Integer

 Valid Range:   5 to 7

                5 = C (Celsius)
                6 = F (Fahrenheit)
                7 =  K (Kelvin)

 Default Value: 5 = C (Celsius)                   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    T S          Type                               ~Z          Scale                                       Error                              ~          Unit                              8 ! #           Instrument ID                                 gTC-R 0 TC-S 1 TC-B 2 TC-J 3 TC-T 4 TC-E 5 TC-K 6 TC-U 7 TC-L 8 TC-N 9 TC-C 10 TC-D 11 TC-G2 12 TC-M 13    IPTS 68 0 ITS  90 1    	                       C 5 F 6  K 7    1    N     Panel Name:    Get Config TC

 Description:   Gets the configuration of TC.    6     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
 
        0   Success
       -1   Invalid Instrument ID
       -2   Error TC-Type return
       -3   Error TC-Scale return
       -4   Error TC-Unit return
       

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Unit

 Description:   Displays the tc-temperature unit.

 Variable Type: Integer

 Valid Range:   5 to 7

                5 = C (Celsius)
                6 = F (Fahrenheit)
                7 =  K (Kelvin)

                   Control Name:   Type

 Description:    Displays the TC-Type.

 Variable Type:  Integer

 Valid Values:   0 = R
                 1 = S
                 2 = B
                 3 = J
                 4 = T
                 5 = E
                 6 = K
                 7 = U
                 8 = L
                 9 = N
                10 = C
                11 = D
                12 = G2
                13 = M

           Control Name:  Scale

 Description:   Displays the tc-temperature scale.

 Variable Type: Integer

 Valid Range:   0 to 1

                0 = IPTS 68
                1 = ITS 90

     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    ݄          Error                              ~ j          Unit                               ~           Type                              ^ ~f          Scale                              2 '           Instrument ID                      	            	            	            	            1         Panel Name:    Get TC Voltage Extern

 Description:   Gets the external TC-voltage values U(T) 
                and U(0C).  
                         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Unit U(T) return
       -3   Invalid Unit U(0C) return


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

               Control Name:  Value U(T)

 Description:   Displays the voltage-value of the
                external tc-temperature U(T).

 Variable Type: Double

          Control Name:  Value U(0C)

 Description:   Displays the voltage-value of the
                external tc-temperature U(0C).

 Variable Type: Double

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Unit U(T)

 Description:   Displays the voltage-unit of the 
                external tc-temperature value U(T).

 Variable Type: Integer

 Valid Range:   0 to 2

                0 =  Volt
                1 = m Volt
                2 = Volt
         Control Name:  Unit U(0C)

 Description:   Displays the voltage-unit of the 
                external tc-temperature value U(0C).

 Variable Type: Integer

 Valid Range:   0 to 2

                0 =  Volt
                1 = m Volt
                2 = Volt
    %
         Error                             G I          Value U(T)                                   Value U(0C)                       2 (           Instrument ID                      IY          Unit U(T)                          Z          Unit U(0C)                        	            	           	           1    	            	                 Panel Name:    Get Din Coefficient PT100

 Description:   Gets the values of the DIN EN PT100 
                coefficients.
                          Control Name:     R0

 Description:      Displays the value of R0.

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

               Control Name:     Coefficient "A"

 Description:      Displays the value of Coefficient "A".

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double
          Control Name:     Coefficient "B"

 Description:      Displays the value of Coefficient "B".

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double
          Control Name:     Coefficient "C"

 Description:      Displays the value of Coefficient "C".

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double
          Control Name:     t100

 Description:      Displays the value of t100.

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.     y 
    Z    R0                                          Error                              y q    Z    Coefficient "A"                    y     Z    Coefficient "B"                    y?         Coefficient "C"                    y         t100                              ,                                           +                                           p ( &           Instrument ID                      	           	            	           	           	           	           L Formula at -200C to 0C:     Rt = R0 [1 + At + Bt^2 + C [t - t100] * t^3]    7 Formula at 0C to 850C:     Rt = R0 [1 + At + Bt^2 ]    1    j     Panel Name:    Get Config Coefficient PT100

 Description:   Gets the values of the PT100 coefficients.          Control Name:     R0

 Description:      Displays the value of R0.

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double

          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

                Control Name:     Coefficient "A"

 Description:      Displays the value of Coefficient "A".

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double
          Control Name:     Coefficient "B"

 Description:      Displays the value of Coefficient "B".

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double
          Control Name:     Coefficient "C"

 Description:      Displays the value of Coefficient "C".

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double
          Control Name:     t100

 Description:      Displays the value of t100.

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.     y 
    Z    R0                                          Error                             ~ y q    Z    Coefficient "A"                  w y     Z    Coefficient "B"                  p y?         Coefficient "C"                  i y         t100                              ,                                           +                                          L ) $           Instrument ID                      	           	            	           	           	           	           L Formula at -200C to 0C:     Rt = R0 [1 + At + Bt^2 + C [t - t100] * t^3]    7 Formula at 0C to 850C:     Rt = R0 [1 + At + Bt^2 ]    1    j     Panel Name:    Set Config Coefficient PT100

 Description:   Sets the values of the PT100 coefficients.          Control Name:     R0

 Description:      Specifies the R0.

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double

 Default:          0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

                Control Name:     Coefficient "A"

 Description:      Specifies the Coefficient "A".

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double

 Default:          0.0          Control Name:     Coefficient "B"

 Description:      Specifies the Coefficient "B".

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double

 Default:          0.0          Control Name:     Coefficient "C"

 Description:      Specifies the Coefficient "A".

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double

 Default:          0.0          Control Name:     t100

 Description:      Specifies the t100.

 Formula:
 at -200C to 0C: Rt = R0 [1 + At + Bt^2 + C [t - t100] t^3]

 at 0C to 850C:  Rt = R0 [1 + At + Bt^2 ]

 Variable Type:    Double

 Default:          0.0    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    y 
    Z    R0                               	          Error                            g y s    Z    Coefficient "A"                  
o y     Z    Coefficient "B"                   m                                          w y?         Coefficient "C"                   y         t100                              n                                          q .             Instrument ID                      0.0    	            0.0    0.0    L Formula at -200C to 0C:     Rt = R0 [1 + At + Bt^2 + C [t - t100] * t^3]    0.0    0.0    7 Formula at 0C to 850C:     Rt = R0 [1 + At + Bt^2 ]    1         Panel Name:    Get Config Output Limit

 Description:   Gets the specified voltage- and current- 
                limit values.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

               Control Name:   Voltage Limit Value

 Description:    Displays the voltage limit value 
                 at the current output state.

 Variable Type:  Integer

 Valid Range:    Voltage 1 to 30 V
                 
           Control Name:   Current Limit Value

 Description:    Displays the current limit value 
                 at the voltage output state.

 Variable Type:  Integer

 Valid Range:    Current 1 to 52 mA
                 
 
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.            Error                                                                                                                             Voltage Limit Value              ~ D          Current Limit Value              b ( *           Instrument ID                      	            V    mA    	            	            1    ]     Panel Name:    Set Config Output Limit Volt

 Description:   Sets the voltage limit value.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Voltage Limit Value


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

               Control Name:   Voltage Limit Value

 Description:    Specifies the voltage limit value 
                 at the current output state.

 Variable Type:  Integer

 Valid Range:    Voltage 1 to 32 V
                 
 Default:        32 V
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:   Device Version
 Description:    Switch between the 30 Volts and 60 Volts
                 Device Version of Digistant 4462.
                 The 60 Volts Version is comming since 
                 Device Software Version 200201.

 Variable Type:  Integer

 Valid Values:   0 = 30 Volts Version
                 1 = 60 Volts Version

 Default Value:  0 = 30 Volts Version   j          Error                            h            Voltage Limit Value              &                                           ` + 2           Instrument ID                    ! o         Device Version                     	            32    V    1               30 V 0 60 V 1    `     Panel Name:    Set Config Output Limit Current

 Description:   Sets the current limit value.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Current Limit Value


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

               Control Name:   Current Limit Value

 Description:    Specifies the current limit value 
                 at the voltage output state.

 Variable Type:  Integer

 Valid Range:    Current 1 to 55 mA
                 
 Default:        55 mA
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:   Device Version
 Description:    Switch between the 30 Volts and 60 Volts
                 Device Version of Digistant 4462.
                 The 60 Volts Version is comming since 
                 Device Software Version 200201.

 Variable Type:  Integer

 Valid Values:   0 = 30 Volts Version
                 1 = 60 Volts Version

 Default Value:  0 = 30 Volts Version   $          Error                            '            Current Limit Value              O                                          ( < .           Instrument ID                    )          Device Version                     	            55    mA    1               30 V 0 60 V 1         Panel Name:    Get Config Output Status

 Description:   Gets the configuration of the 
                output value and unit.
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Error Unit return
       

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          s     Control Name:   Value

 Description:    Displays the output value.
                 

 Variable Type:  Double

          Control Name:   Unit

 Description:    Displays the unit of the output value.

 Variable Type:  Integer

 Valid Range:    0 to 7

                 0 = Voltage (V)       
                 1 = Voltage (mV)
                 2 = Voltage (V)
                 3 = Current (A)       
                 4 = Current (mA)
                 5 = Temperature (C)       
                 6 = Temperature (F)
                 7 = Temperature ( K)


    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   -K         Error                            0E e         Value                            0            Unit                             2 ; C           Instrument ID                      	            	           	            1    \     Panel Name:    Set Config Output Status

 Description:   Sets the output value and unit.
         Control Name:   Value

 Description:    Specifies the output value.
                 

 Variable Type:  Double

 Valid Range:    Voltage -30 to 30 V
                 Current -52 to 52 mA
                 TC    -3000 to 3000 K 
                 
 Default:        0.0

    O     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Unit
       -3   Invalid Voltage Value
       -4   Invalid Current Value
       -5   Invalid Temperature Value

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

              Control Name:   Unit

 Description:    Specifies the unit of the output value.

 Variable Type:  Integer

 Valid Range:    0 to 7

                 0 = Voltage (V)       
                 1 = Voltage (mV)
                 2 = Voltage (V)
                 3 = Current (A)       
                 4 = Current (mA)
                 5 = Temperature (C)       
                 6 = Temperature (F)
                 7 = Temperature ( K)

 Default Value:  0 = Voltage (V)  
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:   Device Version
 Description:    Switch between the 30 Volts and 60 Volts
                 Device Version of Digistant 4462.
                 The 60 Volts Version is comming since 
                 Device Software Version 200201.

 Variable Type:  Integer

 Valid Values:   0 = 30 Volts Version
                 1 = 60 Volts Version

 Default Value:  0 = 30 Volts Version   5 6         Value                            6'          Error                            9~           Unit                             ;a 5 $           Instrument ID                    <          Device Version                         	                       Voltage [V] 0 Voltage [mV] 1 Voltage [V] 2 Current [A] 3 Current [mA] 4 Temperature [C] 5 Temperature [F] 6 Temperature [K] 7    1               30 V 0 60 V 1         Panel Name:    Set Config Output Mode

 Description:   Switch to the normal mode or the selected 
                ramp mode of the instrument.         Control Name:   Mode

 Description:    This parameter switches the
                 Ramp Mode of the device.

 Variable Type:  Integer

 Valid Values:   0 = OFF / Normal
                 1 = Ramp1
                 2 = Ramp2

 Default:        0 = OFF / Normal         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Ramp Mode

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

         )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   @            Mode                             A          Error                            D 0 '           Instrument ID                                 Normal 0 Ramp1 1 Ramp2 2    	            1         Panel Name:    Get Config Output Mode

 Description:   Gets the specified mode of the instrument in  
                following ways:

                - Normal mode
                - Ramp 1 mode
                - Ramp 2 mode         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Error Ramp Mode return

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

               Control Name:   Mode

 Description:    Displays the Ramp Mode of the device.

 Variable Type:  Integer

 Valid Values:   0 = OFF / Normal
                 1 = Ramp1
                 2 = Ramp2

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   Gw          Error                            Jn            Mode                             K: !            Instrument ID                      	            	            1         Panel Name:    Set Config Sense

 Description:   Sets the configuration for the sense in 
                following ways:

                - External
                - Internal
          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Sense Mode


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

               Control Name:   Mode

 Description:    Specifies the Sense Mode of the device.

 Variable Type:  Integer

 Valid Values:   0 = Sense Internal
                 1 = Sense External
                
 Default Value:  0 = Sense Internal
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   M          Error                            P            Mode                             Q ( .           Instrument ID                      	            External 1 Internal 0    1         Panel Name:    Get Config Sense

 Description:   Gets the configuration of the sense in 
                following ways:

                - External
                - Internal
          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Error Sense Mode return

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

               Control Name:   Mode

 Description:    Displays the Sense Mode of the device.

 Variable Type:  Integer

 Valid Values:   0 = Sense Internal
                 1 = Sense External
                
 
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   T          Error                            Wx            Sense Mode                       XG *            Instrument ID                      	            	            1    [     Panel Name:    Set Config Display Mode

 Description:   Sets the status of the display.          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Display Mode

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

              Control Name:   Mode

 Description:    Specifies the Status of the
                 Display Mode of the device.

 Variable Type:  Integer

 Valid Values:   0 = Delta X  /  Limit Value
                 1 = TC-Typ   /  RJ-Temperature
                 2 = TC-Typ   /  U(t)
                 3 = TC-Typ   /  U(0)

                 4 = Output Value
                 5 = PT100 Temperature


 Default Value:  0 = Delta X  /  Limit Value
     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   Z          Error                            ] k2         Mode                             _E 0            Instrument ID                      	                       \Delta X 0 TC-Typ/RJ-Temp 1 TC-Type/U(t) 2 TC-Type/U(0) 3 Output-Value 4 PT100 Temperature 5    1    i     Panel Name:    Set Config Display Contrast

 Description:   Sets the contrast value for the display.
          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Display Contrast

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

               Control Name:   Display Contrast

 Description:    Specifies the contrast value 
                 for the Display.

 Variable Type:  Double

 Valid Values:   0.0 to 1.0 


 Default Value:  0.5 
     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   b          Error                            d           Display Contrast                 e $ 8           Instrument ID                      	            0.5    1    f     Panel Name:    Get Config Display Contrast

 Description:   Gets the contrast value of the display.          Control Name:  Display Contrast

 Description:   Displays the display contrast value.


 Variable Type: Double

 Valid Range:   0.0 - 1.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

         )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   h q         Display Contrast                 h          Error                            k 9            Instrument ID                      	           	            1    h     Panel Name:    Get Config Device Access

 Description:   Gets the access configuration of the device.    K     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID


 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
          Control Name:  Output Function

 Description:   This parameter gets the state of
                output function access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Ramp Function

 Description:   This parameter gets the state of the
                ramp function access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Ramp1

 Description:   This parameter gets the state of the
                ramp1 menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Ramp2

 Description:   This parameter gets the state of the
                ramp2 menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Recall Config

 Description:   This parameter gets the state of the 
                recall configuration menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Store Config

 Description:   This parameter gets the state of the
                store config menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Delta Value

 Description:   This parameter gets the state of the
                delta value menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Sense Config

 Description:   This parameter gets the state of the
                sense config menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Output Limit

 Description:   This parameter gets the state of the
                output limit menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  TC-Config

 Description:   This parameter gets the state of the
                TC-configuration menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Divide Config

 Description:   This parameter gets the state of the
                divide configuration menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Range Mode

 Description:   This parameter gets the state of the
                range mode menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  RJ-Config

 Description:   This parameter gets the state of the
                RJ-configuration menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  PT100 Scale

 Description:   This parameter gets the state of the
                PT100 scale menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Device Store

 Description:   This parameter gets the state of the
                device store menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Device Recall

 Description:   This parameter gets the state of the
                device recall menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Interface

 Description:   This parameter gets the state of the
                interface menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Contrast

 Description:   This parameter gets the state of the 
                contrast menu access.
                

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Status Display

 Description:   This parameter gets the state of the
                status display menu access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Speech Config

 Description:   This parameter gets the state of
                speech configuration access.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   m!         Error                            p?            Output Function                  q Y          Ramp Function                    q           Ramp1                            r c 
          Ramp2                            sq cW          Recall Config                    tP c           Store Config                     u% c x          Delta Value                      u c 	         Sense Config                     v   
         Output Limit                     w W 
         TC-Config                        xx            Divide Config                    yV  z          Range Mode                       z'           RJ-Config                        z            PT100 Scale                      {  z          Device Store                     |            Device Recall                    }| V          Interface                        ~K           Contrast                         *#           Status Display                     z          Speech Config                     " 
           Instrument ID                      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            1    i     Panel Name:    Set Config Device Access

 Description:   Sets the access configuration for the device.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid Speech menu
 -3     Invalid Output Mode menu
 -4     Invalid Ramp Mode menu
 -5     Invalid Ramp1 menu
 -6     Invalid Ramp2 menu
 -7     Invalid Delta Value menu
 -8     Invalid Store Configuration menu
 -9     Invalid Recall Configuration menu
 -10     Invalid Sense menu
 -11     Invalid Output Limit menu
 -12     Invalid Range Mode menu
 -13     Invalid Divide Configuration menu
 -14     Invalid TC-Configuration menu
 -15     Invalid RJ-Configuration menu
 -16     Invalid PT100 Scale menu
 -17     Invalid Device Store menu
 -18     Invalid Device Recall menu
 -19     Invalid Interface menu
 -20     Invalid Contrast menu
 -21     Invalid Status Display menu

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
         Control Name:  Output Function

 Description:   This parameter activate or
                deactivate the access to the 
                output function.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON  

 Default Value: 1 = ON 
         Control Name:  Ramp Function

 Description:   This parameter activate or
                deactivate the access to the 
                ramp function menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   

 Default Value: 1 = ON           Control Name:  Ramp1

 Description:   This parameter activate or
                deactivate the access to the 
                ramp1 menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   

 Default Value: 1 = ON          Control Name:  Ramp2

 Description:   This parameter activate or
                deactivate the access to the 
                ramp2 menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   

 Default Value: 1 = ON
         Control Name:  Recall Config

 Description:   This parameter activate or
                deactivate the access to the 
                recall configuration menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON  

 Default Value: 1 = ON 
         Control Name:  Store Config

 Description:   This parameter activate or
                deactivate the access to the 
                store configuration menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   

 Default Value: 1 = ON          Control Name:  Delta Value

 Description:   This parameter activate or
                deactivate the access to the 
                delta value menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   

 Default Value: 1 = ON    	     Control Name:  Sense Config

 Description:   This parameter activate or
                deactivate the access to the 
                sense configuration menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   

 Default Value: 1 = ON
         Control Name:  Output Limit

 Description:   This parameter activate or
                deactivate the access to the 
                output limit menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON  

 Default Value: 1 = ON 
         Control Name:  TC-Config

 Description:   This parameter activate or
                deactivate the access to the 
                TC-configuration menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON 

 Default Value: 1 = ON  
         Control Name:  Divide Config

 Description:   This parameter activate or
                deactivate the access to the 
                divide configuration menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   

 Default Value: 1 = ON
          Control Name:  Range Mode

 Description:   This parameter activate or
                deactivate the access to the 
                range mode menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   

 Default Value: 1 = ON
         Control Name:  RJ-Config

 Description:   This parameter activate or
                deactivate the access to the 
                RJ-configuration menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   

 Default Value: 1 = ON          Control Name:  PT100 Scale

 Description:   This parameter activate or
                deactivate the access to the 
                PT100 scale menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   

 Default Value: 1 = ON
         Control Name:  Device Store

 Description:   This parameter activate or
                deactivate the access to the 
                device store menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON  

 Default Value: 1 = ON 
         Control Name:  Device Recall

 Description:   This parameter activate or
                deactivate the access to the 
                device recall menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   

 Default Value: 1 = ON
          Control Name:  Interface

 Description:   This parameter activate or
                deactivate the access to the 
                interface menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   

 Default Value: 1 = ON
    
     Control Name:  Contrast

 Description:   This parameter activates or
                deactivates the access to the 
                contrast menu.
                

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON

 Default Value: 1 = ON   
         Control Name:  Status Display

 Description:   This parameter activate or
                deactivate the access to the 
                status display menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   

 Default Value: 1 = ON
         Control Name:  Speech Config

 Description:   This parameter activate or
                deactivate the access to the 
                speech configuration menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   

 Default Value: 1 = ON     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   	         Error                                        Output Function                    w          Ramp Function                                Ramp1                             ] )          Ramp2                             ]v          Recall Config                    ( ]          Store Config                     8 ]           Delta Value                      ? ] 	         Sense Config                     P  ) 
         Output Limit                     Z v 
         TC-Config                        e           Divide Config                    x            Range Mode                       ~           RJ-Config                          (          PT100 Scale                                  Device Store                                Device Recall                     s          Interface                                   Contrast                         # )          Status Display                                Speech Config                                  Instrument ID                      	           On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0    1    i     Panel Name:    Get Config Voltage Divider State

 Description:   Gets the mode of the voltage divider.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
      

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

               Control Name:   Divider Mode

 Description:    Displays the divider mode of the device. 
                

 Variable Type:  Integer

 Valid Range:    0 to 1

                 0 = Divider OFF
                 1 = Divider ON

              
           Control Name:   Factor

 Description:    Displays the factor value 
                 of the voltage dividor.

 Variable Type:  Double

 Valid Range:    1.0 to 1010.0

              
     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   9          Error                             \           Divider Mode                      \         Divider Factor                    '            Instrument ID                      	            	            	           1    i     Panel Name:    Set Config Voltage Divider State

 Description:   Sets the mode of the voltage divider.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Divider Mode

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

              Control Name:   Divider Mode

 Description:    Specifies the divider mode of the device. 
                

 Variable Type:  Integer

 Valid Range:    0 to 1

                 0 = Divider OFF
                 1 = Divider ON

              
 Default Value:  0 = Divider OFF    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   p          Error                            e \1          Divider Mode                      3 3           Instrument ID                      	            On 1 Off 0    1    l     Panel Name:    Set Config Voltage Divider

 Description:   Sets the factor value for the voltage divider.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Divider Factor Value

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

               Control Name:   Divider Factor

 Description:    Specifies the factor value 
                 of the voltage dividor.

 Variable Type:  Double

 Valid Range:    1.0 to 1010.0

              
 Default Value:  1.0    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.             Error                                       Divider Factor                    0 *           Instrument ID                      	            1.0    1    ~     Panel Name:    Get Config Delta Value

 Description:   Gets the delta value and unit 
                of the selected type.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Type
       -3   Error Unit return

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

               Control Name:   Value

 Description:    Displays the delta value 
                 of the selected type.

 Variable Type:  Double

          Control Name:   Type

 Description:    Specifies the type of delta value. 
                

 Variable Type:  Integer

 Valid Range:    0 to 2

                 0 = Voltage
                 1 = Current
                 3 = Temperature

              
 Default Value:  0 = Voltage         Control Name:   Unit

 Description:    Displays the unit of the delta value.

 Variable Type:  Integer

 Valid Range:    0 to 7

                 0 = Voltage (V)       
                 1 = Voltage (mV)
                 2 = Voltage (V)
                 3 = Current (A)       
                 4 = Current (mA)
                 5 = Temperature (C)       
                 6 = Temperature (F)
                 7 = Temperature ( K)
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   ,         Error                            7 v         Value                                       Type                                         Unit                             ä : .           Instrument ID                      	            	                      "Voltage 0 Current 1 Temperature 2    	            1    w     Panel Name:    Set Config Delta Value

 Description:   Sets the delta value for the selected unit. 
                    O     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Unit
       -3   Invalid Voltage Value
       -4   Invalid Current Value
       -5   Invalid Temperature Value

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

         c     Control Name:   Value

 Description:    Specifies the delta value 
                 of the selected unit.

 Variable Type:  Double

 Valid Range:   
                 Voltage (V):     0.0 to 60 000 000.0 V     
                 Voltage (mV):     0.0 to 60 000.0 mV
                 Voltage (V):      0.0 to 60.0 V
                 Current (A):     0.0 to 104 000.0 A      
                 Current (mA):     0.0 to 104.0 mA
                 Temperature (C):    
                 Temperature (F):
                 Temperature ( K): 0.0 to 3 000.0 K   
                
              
 Default Value:  0.0    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:   Unit

 Description:    Specifies the unit of the delta value.

 Variable Type:  Integer

 Valid Range:    0 to 7

                 0 = Voltage (V)       
                 1 = Voltage (mV)
                 2 = Voltage (V)
                 3 = Current (A)       
                 4 = Current (mA)
                 5 = Temperature (C)       
                 6 = Temperature (F)
                 7 = Temperature ( K)

 Default Value:  0 = Voltage (V)  
         Control Name:   Device Version
 Description:    Switch between the 30 Volts and 60 Volts
                 Device Version of Digistant 4462.
                 The 60 Volts Version is comming since 
                 Device Software Version 200201.

 Variable Type:  Integer

 Valid Values:   0 = 30 Volts Version
                 1 = 60 Volts Version

 Default Value:  0 = 30 Volts Version   Ʒ          Error                                      Value                            y = 3           Instrument ID                    ͪ           Unit                             ό          Device Version                     	            0.0    1               Voltage [V] 0 Voltage [mV] 1 Voltage [V] 2 Current [A] 3 Current [mA] 4 Temperature [C] 5 Temperature [F] 6 Temperature [K] 7               30 V 0 60 V 1    h     Panel Name:    Set Delta Value Up/Down

 Description:   Sets the direction for the delta value steps.         Control Name:   Step Mode

 Description:    Specifies the step mode 
                 of the delta value. 
                

 Variable Type:  Integer

 Valid Range:    0 to 1

                 0 = Step Down
                 1 = Step Up

              
 Default Value:  0 = Step Down         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Step Mode
      
  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

         )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   X            Step Mode                        }          Error                            u 7 *           Instrument ID                      Up 1 Down 0    	            1    `     Panel Name:    Check TC Option

 Description:   Check if a TC-option is integrated in device.    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

         Control Name:  Option Status

 Description:   Displays the result of TC-option 
                integrated in device.

 Variable Type: Integer

 Valid Range:   0 to 1

                0 = No TC-option integrated 
                1 = TC-option integrated 
                   @ -           Instrument ID                              Error                            ݏ >           Option-Status                      1    	            	                 Panel Name:    Set Lock System Keyboard

 Description:   Sets the System Keyboard of the device 
                to the selected state.          Control Name:  Keyboard

 Description:   This parameter locks the keyboard
                on the front panel of the
                instrument.

 Variable Type: Integer

 Valid Range:   0  = Unlocked
                1  = Locked         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Value

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    m           Keyboard                                   Error                             .            Instrument ID                      Locked 1 Unlocked 0    	            1    w     Panel Name:    Get Lock System Keyboard

 Description:   Gets the lock state of the System Keyboard.
                        Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Lock-State

 Description:  Displays the lock-state for 
               the front panel of the instrument.

 Variable Type: Integer

 Valid Range:   0  = Unlocked
                1  = Locked    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.             Error                             m          Lock-State                       g 7            Instrument ID                      	            	            1        Panel Name:    Check Device Error Status Output 

 Description:   Check the questionable status register and   
                returns a error-ID if an error occurs.
                
                Checked errors:

                - Voltage output error 
                - Current output error
                - Analog 15V supply error
                - Temperature TC output error
                - Calibrating error
                - PT100 measuring error    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    b     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Error Voltage Output 
      311   Error Current Output 
      312   Error Device Voltage 15 Volt Analog
      313   Error Temperature Output
      314   Error Calibration
      315   Error PT 100 Measure

   * > 5           Instrument ID                    [          Error                              1    	                Panel Name:    Check Device Error Status Temperature

 Description:   Checks the status of a temperature measurement 
                in the questionable status temperature register  
                and returns an error-ID if an error occurs.
                
                Checked errors:

                - Break of a cable by current measuring
                - Break of a cable by voltage measuring
                - Resistor (PT100) out of range
                - Invalid temperature
     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Current Cable Error 
      321   Voltage Cable Error
      322   PT 100 Out of Range 
      323   Invalid Temperature
   8 > 5           Instrument ID                    i          Error                              1    	                Panel Name:    Check Device Error Status Source

 Description:   Checks the status of the output 
                in the questionable status output register  
                and returns an error-ID if an error occurs.
                
                Checked errors:

                - Overrange of the end stage
                - PT100 source error
                - Overrange of the D/A converter
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      316   Error Output Overrange
      317   Error PT 100
      318   Error D/A-Converter Overrange

    > 5           Instrument ID                              Error                              1    	                 Panel Name:    Get System Error

 Description:   Gets an actually error ID from device 
                if an error occours.     n     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success, No Error
       -1   Invalid Instrument ID
     -100   Command error
     -101   Invalid character in the SCPI-command
     -105   Get-command not allowed
     -109   Missing Parameter in the SCPI-syntax
     -110   Command header error
     -120   Invalid numeric data error
     -200   Execution error
     -204   Illegal device state
     -213   No init command allowed
     -220   SCPI-command contained invalid parameter
     -221   Setting conflict
     -222   Data out of range
     -224   Illegal parameter value
     -231   Data value is questionable
     -350   Query overflow
     -400   Query error
     -410   Query interrupted
     -420   Query unterminated

      110   Voltage overrange
      210   Current overrange
      300   15 Volt analogue power failure
      510   Temperature overrange
      520   PT 100 error
      602   Out over

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator


    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.             Error                            4 7            Instrument ID                      	            1         Panel Name:   Receive a SCPI-Message

 Description:  Sends "Query form" from SCPI-
               Message and receive a answers
         Control Name:  Send SCPI-Message

 Description:   This control is a string parameter
                You must input Query-Form from
                the SCPI-message without the
                LineFeed termination.

 Example      : "Sour:volt?"

 Variable Type: String          Control Name:  Answer from Slave

 Description:   This control return a string from
                the slave.

 Variable Type: String (Lenght => see the 4462
                        Manual SCPI-Commands)    M     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID


 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT


    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   k           Send-SCPI-Message                 $         Answer from Slave                	Y          Error                             ( (           Instrument ID                          	            	            1    c     Panel Name:   Send a SCPI-Message

 Description:  Sends a SCPI-Message to a
               slave          Control Name:  Send SCPI-Message

 Description:   This control is a string parameter
                You must input the SCPI-message
                without the LineFeed termination.

 Example:       "SOUR:VOLT 10V"

 Variable Type: String
    M     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID


 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT


    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   ?           Send-SCPI-Message                :          Error                             ) &           Instrument ID                          	            1         Panel Name:   Read Standard Event Status Register

 Description:  Reads the individual error bits of 
               the Standard Event Status Register.
          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Register Value

 Description:   Return the 8 bit integer value of 
                the register. 
                
               
 Variable Type: 8-bit Integer

 
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Bit 0

 Description:   Return the value of Bit 0 from 
                the register. 
                
                'Operation Complete'                

 Variable Type: Integer

 
          Control Name:  Bit 2

 Description:   Return the value of Bit 2 from 
                the register. 
                
                'Query Error'                

 Variable Type: Integer

 
          Control Name:  Bit 3

 Description:   Return the value of Bit 3 from 
                the register. 
                
                'Device Dependent Error'                

 Variable Type: Integer

 
          Control Name:  Bit 4

 Description:   Return the value of Bit 4 from 
                the register. 
                
                'Execution Error'                

 Variable Type: Integer

 
          Control Name:  Bit 5

 Description:   Return the value of Bit 5 from 
                the register. 
                
                'Command Error'                

 Variable Type: Integer

 
            Error                             .           Register Value                    /            Instrument ID                                Bit 0                             
          Bit 2                            u x          Bit 3                            K            Bit 4                                       Bit 5                            S                                                                                      "                                          s                                                                                                                                 	            	           1    	            	            	            	            	            8-bit Integer Value    Operation Complete    Query Error    Dev. Dependent Error    Execution Error    Command Error   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   .           Register Value                           Error                              , )           Instrument ID                    {           Bit 0                            zO          Bit 8                            Q                                                                                      U                                            	           	            1    	            	            16-bit Integer Value    Calibration Error    Cal Measure Flag   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   .           Register Value                           Error                            # , )           Instrument ID                    {           Bit 0                            zO          Bit 8                            Q                                                                                      U                                            	           	            1    	            	            16-bit Integer Value    Calibration Error    Cal Measure Flag         Panel Name:   Read Questionable Status Event Register

 Description:  Reads the individual error bits of 
               the Questionable Status Event Register.
          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Register Value

 Description:   Return the 16 bit integer value of 
                the register. 
                
               
 Variable Type: 16-bit Integer

 
          Control Name:  Bit 0

 Description:   Return the value of Bit 0 from 
                the register. 
                
                'Voltage Error'                

 Variable Type: Integer

 
          Control Name:  Bit 1

 Description:   Return the value of Bit 1 from 
                the register. 
                
                'Current Error'                

 Variable Type: Integer

 
          Control Name:  Bit 3

 Description:   Return the value of Bit 3 from 
                the register. 
                
                'Power Error'                

 Variable Type: Integer

 
          Control Name:  Bit 4

 Description:   Return the value of Bit 4 from 
                the register. 
                
                'Temperature Error'                

 Variable Type: Integer

 
          Control Name:  Bit 8

 Description:   Return the value of Bit 8 from 
                the register. 
                
                'Calibration Error'                

 Variable Type: Integer

 
          Control Name:  Bit 9

 Description:   Return the value of Bit 9 from 
                the register. 
                
                'PT 100 Error'                

 Variable Type: Integer

 
   '         Error                            * % &           Instrument ID                    + "           Register Value                   , q           Bit 0                            -w q/          Bit 1                            .D q          Bit 3                            /            Bit 4                            / 0          Bit 8                            0           Bit 9                            F                                                                                      @                                                                                                                               9                                                                                      	            1    	           	            	            	            	            	            	            16-bit Integer Value    Voltage Error    Current Error    Power Error    Temperature Error    Calibration Error    PT100 Error         Panel Name:   Read Questionable Status Output Register

 Description:  Reads the individual error bits of 
               the Questionable Status Output Register.
          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Register Value

 Description:   Return the 8 bit hex value of 
                the register. 
                
               
 Variable Type: 8-bit Hexadecimal

 
          Control Name:  Bit 0

 Description:   Return the value of Bit 0 from 
                the register. 
                
                'Output Stage Overrange'                

 Variable Type: Integer

 
          Control Name:  Bit 3

 Description:   Return the value of Bit 3 from 
                the register. 
                
                'PT 100 Output Error'                

 Variable Type: Integer

 
          Control Name:  Bit 4

 Description:   Return the value of Bit 4 from 
                the register. 
                
                'D/A Device Error'                

 Variable Type: Integer

 
   6c         Error                            93 1 ,           Instrument ID                    :d 6           Register Value                   ;"            Bit 0                            ; K          Bit 3                            <           Bit 4                            [                                                                                      P                                                                                      	            1    	           	            	            	            8-bit Hex Value    Output Stage Overrange    PT100 Output Error    D/A-Device Overrange         Panel Name:   Read Questionable Status Temperature Register

 Description:  Reads the individual error bits of 
               the Questionable Status Temperature Register.
          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Register Value

 Description:   Return the 8 bit hex value of 
                the register. 
                
               
 Variable Type: 8-bit Hexadecimal

 
          Control Name:  Bit 0

 Description:   Return the value of Bit 0 from 
                the register. 
                
                'Current Wire Error'                

 Variable Type: Integer

 
          Control Name:  Bit 1

 Description:   Return the value of Bit 1 from 
                the register. 
                
                'Voltage Wire Error'                

 Variable Type: Integer

 
          Control Name:  Bit 2

 Description:   Return the value of Bit 2 from 
                the register. 
                
                'PT 100 Overrange'                

 Variable Type: Integer

 
          Control Name:  Bit 3

 Description:   Return the value of Bit 3 from 
                the register. 
                
                'Invalid Temperature'                

 Variable Type: Integer

 
   A         Error                            C 3 +           Instrument ID                    E *           Register Value                   E x           Bit 0                            F x5          Bit 1                            Ge x          Bit 2                            H5            Bit 3                            M                                                                                      7                                                                                                                                 	            1    	           	            	            	            	            8-bit Hex Value    Current Wire Error    Voltage Wire Error    PT100 Overrange    Invalid Temerature         Panel Name:   Reset Questionable/Operation Status Enable
               Register

 Description:  Resets the Questionable/Operation Status 
               Enable Register.
          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   L         Error                            O 3 +           Instrument ID                      	            1    w     Panel Name:   Set Memory Label

 Description:  Sets the label text of a 
               selected device memory ID.
          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State
       -3   Memory label to long

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Memory No.

 Description:   Specificies the memory No. to 
                store the label text

 Variable Type: Integer

 Valid Range:   1 -  33
          Control Name:  Memory Label

 Description:   Specifices the memory label text.

 Variable Type: String

 Valid Range:   max. 10 Byte
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   Q          Error                            T t          Memory No.                       U t-         Memory Label                     (                                                                                     V2 %            Instrument ID                      	               !                     (max. Length 10 Byte)    (No 1 = Default)    1    w     Panel Name:   Get Memory Label

 Description:  Gets the label text of a 
               selected device memory ID.
          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Memory ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Memory No.

 Description:   Specificies the memory No. to the
                recalled label text in the device.

 Variable Type: Integer

 Valid Range:   1 -  33
     {     Control Name:  Memory Label

 Description:   Displays the memory label text.

 Variable Type: String (10 Byte + NULL)


    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   Yy          Error                            \g t          Memory No.                       ]$ t-         Memory Label                                                                ] - *           Instrument ID                      	               !                 	            (No 1 = Default)    1         Panel Name:    Set Store Output Value

 Description:   Stores the actually output and delta value 
                under a specified memory No. in the device.
           Control Name:   Memory No.

 Description:    Specifies the Memory No. of the stored 
                 output and delta value.

 Variable Type:  integer

 Valid Range:    0 to 99

 Default:        0
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Memory No.

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   `      2    Memory No.                       a          Error                                                                       d 0 3           Instrument ID                         c                   	            (No 0 = Default)    1         Panel Name:    Get Store Output Value

 Description:   Displays the stored output and delta value
                under the selected memory No. with value unit.
     5     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Memory No.
       -3   Error Output Unit return
       -4   Error Delta Unit return

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

                Control Name:   Memory No.

 Description:    Specifies the Memory No. of the stored
                 output and delta value.

 Variable Type:  integer

 Valid Range:    0 to 99

 Default:        0
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Output Value

 Description:    Displays the output value 
                 of the selected memory No.

 Variable Type:  Double

           Control Name:   Delta Value

 Description:    Displays the delta value 
                 of the selected memory No.

 Variable Type:  Double

          Control Name:   Output Unit

 Description:    Displays the unit of the output value.

 Variable Type:  Integer

 Valid Range:    0 to 7

                 0 = Voltage (V)       
                 1 = Voltage (mV)
                 2 = Voltage (V)
                 3 = Current (A)       
                 4 = Current (mA)
                 5 = Temperature (C)       
                 6 = Temperature (F)
                 7 = Temperature ( K)
         Control Name:   Delta Unit

 Description:    Displays the unit of the delta value.

 Variable Type:  Integer

 Valid Range:    0 to 7

                 0 = Voltage (V)       
                 1 = Voltage (mV)
                 2 = Voltage (V)
                 3 = Current (A)       
                 4 = Current (mA)
                 5 = Temperature (C)       
                 6 = Temperature (F)
                 7 = Temperature ( K)
   g          Error                            j +     2    Memory No.                       A                                           k ( "           Instrument ID                    l ~          Output Value                     mz           Delta Value                      n  (          Output Unit                      o  '          Delta Unit                         	               c                   (No 0 = Default)    1    	           	           	            	                 Panel Name:    Set Store ID Output Value

 Description:   Stores the specified output and delta value
                under the selected memory No. with value unit.
     7     Control Name:   Output Value

 Description:    Specifies the output value of the
                 selected memory No.

 Variable Type:  Double

 Valid Range:    by Voltage -30 to 30 V
                 by Current -52 to 52 mA
                 by TC        0 to 3000 K 
                 
 Default:        0.0

    3     Control Name:   Delta Value

 Description:    Specifies the delta value of the
                 selected memory No.

 Variable Type:  Double

 Valid Range:    by Voltage -30 to 30 V
                 by Current -52 to 52 mA
                 by TC        0 to 3000 K 
                 
 Default:        0.0    [     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Memory No.
       -3   Error Output Unit return
       -4   Error Delta Unit return
       -5   Invalid Voltage Output Value
       -6   Invalid Current Output Value
       -7   Invalid Temperature Output Value
       -8   Invalid Voltage Delta Value
       -9   Invalid Current Delta Value
       -10  Invalid Temperature Delta Value
       -11  Unequal Output and Delta Types

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:   Output Unit

 Description:    Specifies the unit of the output value.

 Variable Type:  Integer

 Valid Range:    0 to 7

                 0 = Voltage (V)       
                 1 = Voltage (mV)
                 2 = Voltage (V)
                 3 = Current (A)       
                 4 = Current (mA)
                 5 = Temperature (C)       
                 6 = Temperature (F)
                 7 = Temperature ( K)

 Default Value:  0 = Voltage (V)  
         Control Name:   Delta Unit

 Description:    Specifies the unit of the delta value.

 Variable Type:  Integer

 Valid Range:    0 to 7

                 0 = Voltage (V)       
                 1 = Voltage (mV)
                 2 = Voltage (V)
                 3 = Current (A)       
                 4 = Current (mA)
                 5 = Temperature (C)       
                 6 = Temperature (F)
                 7 = Temperature ( K)

 Default Value:  0 = Voltage (V)  
          Control Name:   Memory No.

 Description:    Specifies the Memory No. of the stored
                 output and delta value.

 Variable Type:  integer

 Valid Range:    0 to 99

 Default:        0
         Control Name:   Device Version
 Description:    Switch between the 30 Volts and 60 Volts
                 Device Version of Digistant 4462.
                 The 60 Volts Version is comming since 
                 Device Software Version 200201.

 Variable Type:  Integer

 Valid Values:   0 = 30 Volts Version
                 1 = 60 Volts Version

 Default Value:  0 = 30 Volts Version   t_ n r         Output Value                     u n0         Delta Value                      v          Error                            {< &            Instrument ID                    |m           Output Unit                      ~W o         Delta Unit                       ? (     2    Memory No.                                 Device Version                     0.0    0.0    	            1               Voltage [V] 0 Voltage [mV] 1 Voltage [V] 2 Current [A] 3 Current [mA] 4 Temperature [C] 5 Temperature [F] 6 Temperature [K] 7               Voltage [V] 0 Voltage [mV] 1 Voltage [V] 2 Current [A] 3 Current [mA] 4 Temperature [C] 5 Temperature [F] 6 Temperature [K] 7       c                              30 V 0 60 V 1         Panel Name:    Close Serial

 Description:   Takes the instrument off-line.

 Note: The  instrument must  be reinitialized
       to use it again.    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.   V : $           Instrument ID                             Error                              1    	                  x  "     K.    InitGpib                                 #  .     K.    InitSerial                               1  C     K.    SetConfigRamp1                           G  W 
    K.    GetConfigRamp1                           Z  h 	    K.    SetConfigListRamp2                       kh  v     K.    GetConfigListRamp2                       x       K.    SetConfigRamp2                           "       K.    GetConfigRamp2                             L     K.    SetRampStep                                Z     K.    SetRampStart                      h           &     K.    GetConfigRangeMode                           '     K.    SetConfigRangeMode                E         Z       K.    GetRjTempValue                                  K.    SetRjTempValueMan                          W     K.    GetRjTempValueMan                        T        K.    SetConfigRjType                                 K.    GetConfigRjType                          ̉  &     K.    SetConfigTcUnit                            i     K.    SetConfigTc                              .  N     K.    GetConfigTc                                     K.    GetTcVoltageExtern                
-         U   	    K.    GetConfigDinCoefficient           
         T } 	    K.    GetConfigCoefficient                      0  	    K.    SetConfigCoefficient                    <      K.    GetConfigOutputLimit                     #     K.    SetConfigOutputLimitV                   $` +~     K.    SetConfigOutputLimitC                   , 3     K.    GetConfigOutputStatus                   4 >     K.    SetConfigOutputStatus                   ? E     K.    SetConfigOutputMode                     F Lk     K.    GetConfigOutputMode                     M' R     K.    SetConfigSense                          S Yx     K.    GetConfigSense                            Z4 `v     K.    SetConfigDisplayMode                      a f     K.    SetConfigDisplayContrast                  g l     K.    GetConfigDisplayContrast                  m| 	     K.    GetConfigDeviceAccess             {              K.    SetConfigDeviceAccess                         K.    GetConfigVoltageDivState                      K.    SetConfigVoltageDivState                o      K.    SetConfigVoltageDiv                           K.    GetConfigDeltaValue                     8      K.    SetConfigDeltaValue                      ئ     K.    SetAddDeltaValue                        e ި     K.    CheckTcOption                             d      K.    SetLockSystemKeyboard                         K.    GetLockSystemKeyboard                   T      K.    CheckErrorStatusOutput                  @ |     K.    CheckErrorStatusTemp                          K.    CheckErrorStatusSource                  6 e     K.    GetSystemError                    -              K.    receive_scpi                              
      K.    send_scpi                               t      K.    ReadStdEventStatusReg                   !     K.    ReadOperStatusEventReg                  %     K.    ReadOperStatusCondReg                   '< 1}     K.    ReadQuestStatusEventReg                 5 = 
    K.    ReadQuestStatusOutputReg                @I I     K.    ReadQuestStatusTempReg                  L9 P     K.    ResetQuestOperStEnReg             3        Ql Wc     K.    SetMemoryLabel                            X ^     K.    GetMemoryLabel                    7        `) e     K.    SetStoreOutputValue                       f q     K.    GetStoreOutputValue                     s      K.    SetStoreIdOutputValue                         K.    close                                                                      Initialize                           DInitialize GPIB                      DInitialize Serial                   DConfigure                         Ramp                                Ramp 1                               DSet Config Ramp1                     DGet Config Ramp1                    YRamp 2                               DSet Config List Ramp2                DGet Config List Ramp2                DSet Config Ramp2                     DGet Config Ramp2                     DSet Ramp Step                        DSet Ramp Start/Stop                  Range                                DGet Config Range Mode                DSet Config Range Mode               RJ                                   DGet RJ Temperature Value Ext.        DSet RJ Temperat. Value Manual        DGet RJ Temperat. Value Manual        DSet Config RJ Type                   DGet Config RJ Type                  TC                                   DSet Config TC Unit                   DSet Config TC                        DGet Config TC                        DGet TC Voltage Extern               	PT 100                               DGet Din Coefficient PT100            DGet Config Coefficient PT100         DSet Config Coefficient PT100        &Output                              Limit                                DGet Config Output Limit              DSet Config Output Limit Volt         DSet Config Output Limit Current     
Status / Values                      DGet Config Output Status             DSet Config Output Status            
Mode                                 DSet Config Output Mode               DGet Config Output Mode              Sense                                DSet Config Sense                     DGet Config Sense                    vConfig Display                       DSet Config Display Mode              DSet Config Display Contrast          DGet Config Display Contrast         HDevice Access                        DGet Config Device Access             DSet Config Device Access            Voltage Divider                      DGet Config Voltage Div. State        DSet Config Voltage Div. State        DSet Config Voltage Divider          Delta Value                          DGet Config Delta Value               DSet Config Delta Value               DSet Delta Value Up/Down             aSystem                               DCheck TC Option                      DSet Lock System Keyboard             DGet Lock System Keyboard            EDevice Error                         DCheck Device Err. Status Output      DCheck Device Err. Status Temp.       DCheck Device Err. Status Source      DGet System Error                    SCPI                                 DReceive a SCPI-Message               DSend a SCPI-Message                 ?Register                             DRead Standard Event Status Reg       DRead Operation Status Event Reg      DRead Operation Status Cond. Reg      DRead Quest.Status Event Regist.      DRead Quest. Status Output Reg        DRead Quest Status Temperat. Reg      DReset Quest./Oper.Stat.En.Reg.      Store/Load                           DSet Memory Label                     DGet Memory Label                     DSet Store Output Value               DGet Store Output Value               DSet Store ID Output Value            DClose                           